<?php
include("connexion.php");

if (!isset($_GET['id_reservation'])) {
    die("Erreur: ID de réservation non spécifié.");
}

$id_reservation = intval($_GET['id_reservation']);

// Récupérer les informations de la réservation
$requete_reservation = "
    SELECT reservation.*, salles.nom AS salle_nom, client.prenom, client.nom, client.mail, reservation.prix_total
    FROM reservation
    JOIN salles ON reservation.ext_salles = salles.id_salles
    JOIN client ON reservation.ext_client = client.id_client
    WHERE reservation.id_reservation = :id_reservation";
$stmt_reservation = $db->prepare($requete_reservation);
$stmt_reservation->bindParam(':id_reservation', $id_reservation, PDO::PARAM_INT);
$stmt_reservation->execute();
$reservation = $stmt_reservation->fetch(PDO::FETCH_ASSOC);
$stmt_reservation->closeCursor();

if (!$reservation) {
    die("Erreur: Réservation non trouvée.");
}

// Envoyer l'email de confirmation
$to = $reservation['mail'];
$subject = 'Confirmation de Réservation - Escape Mystère';
$message = '
<html>
<body>
    <header>
        <img class="logo.png" alt="logo" src="">
    </header>
        <h1 id="reservation">Merci d\'avoir réservé une salle !</h1>
        <p>Veuillez vous munir d\'une pièce d\'identité le jour de votre réservation</p>
        <p>À bientôt chez Escape Mystère !</p>
    <div class="texte">
        <br>
        <h2>Réservation au nom de : ' . htmlspecialchars($reservation['prenom']) . ' ' . htmlspecialchars($reservation['nom']) . '</h2>
        <h2>Détails de la commande:</h2>
        <div class="infos">
            <p> Vous avez réservé une salle : <strong>' . htmlspecialchars($reservation['salle_nom']) . '</strong></p>
            <p>Pour le : <strong>' . htmlspecialchars($reservation['date_reservation']) . '</strong></p>
            <p>Le prix de votre réservation est de : <strong>' . htmlspecialchars($reservation['prix_total']) . '€</strong></p>
        </div>
    </div>
</body>
</html>
';

$headers = 'MIME-Version: 1.0' . "\r\n";
$headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";
$headers .= 'From: no-reply@escapemystere.com' . "\r\n";

mail($to, $subject, $message, $headers);

?>

<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="EscapeMystere.css">
    <title>Confirmation</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Stick+No+Bills:wght@200..800&display=swap" rel="stylesheet">

    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Didact+Gothic&display=swap" rel="stylesheet">
</head>

<body>
    <header>
        <nav class="top-nav">
        <a href="#main" class="skip-link">Aller au contenu</a>
            <div>
                <a href="index.html">
                    <img src="Images/logo.png" alt="logo">
                </a>
            </div>
            <ul class="contenu">
                <li><a href="index.php">Accueil</a></li>
                <li><a href="salles.php">Salles</a></li>
                <li><a href="Qui_sommes_nous.html">Qui sommes nous ?</a> </li>
            </ul>
        </nav>
    </header>

    <main role="main" id="main" tabindex="-1">
    <div class="confirmation">
        <p>Merci pour votre réservation</p>
        <p>Allez regarder votre boîte mail!</p>
        <button><a href="accueil.php">Retour à l'accueil</a></button>
        <label for="prix">Prix total:</label>
        <input type="text" id="prix" name="prix" value="<?php echo htmlspecialchars($reservation['prix_total']); ?> €" readonly><br><br>
</div>




</body>
</html>