<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="./Style/style.css">
    <title>Mon Profil</title>
</head>

<body class="bodyProfile">
    <header>
        <!-- Affichage de la photo de profil si l'utilisateur est connecté -->
        <?php if (connected_user() && !empty($comments)): ?>
            <div class="logo">
                <img src="./uploads/<?= htmlspecialchars($comments['photo_profil']) ?>" alt="Photo de profil">
            </div>
        <?php endif; ?>

        <!-- Menu de navigation -->
        <nav>
            <ul>
                <li><a href="index.php?action=home">Accueil</a></li>
                <li><a href="index.php?action=showArchives">Archives</a></li>

                <?php if (isAdmin()): ?>
                    <li><a href="index.php?action=precreate_post">Ajouter un Billet</a></li>
                    <li><a href="index.php?action=administration">Administration</a></li>
                <?php endif; ?>
            </ul>
        </nav>

        <!-- Navigation de droite pour profil ou liens de connexion -->
        <div class="right-nav">
            <ul>
                <?php if (connected_user()): ?>
                    <li><a href="index.php?action=profile">Mon Profil</a></li>
                <?php else: ?>
                    <li><a href="index.php?action=login">Connexion</a></li>
                    <li><a href="index.php?action=inscription">Inscription</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </header>

    <!-- Section de profil utilisateur -->
    <section class="profile-container">
        <div class="container-profile">
            <h1 class="profile-title">Informations de l'utilisateur</h1>

            <!-- Affichage des informations de profil -->
            <div class="profile-info">
                <p class="profile-detail">
                    <span class="detail-label">Login :</span> <?= htmlspecialchars($_SESSION['user']) ?>
                </p>
                <p class="profile-detail">
                    <span class="detail-label">Prénom :</span> <?= htmlspecialchars($_SESSION['prenom']) ?>
                </p>
                <p class="profile-detail">
                    <span class="detail-label">Nom :</span> <?= htmlspecialchars($_SESSION['nom']) ?>
                </p>
            </div>

            <!-- Formulaire de modification de la photo de profil -->
            <h2 class="profile-subtitle">Modifier la photo de profil</h2>
            <form action="index.php?action=upload" method="POST" enctype="multipart/form-data" class="profile-form">
                <input type="file" name="photo_profil" accept="image/*" class="file-input" required>
                <br>
                <button type="submit" class="upload-button">Ajouter la photo</button>

                <!-- Affichage des erreurs liées à l'upload -->
                <?php if (isset($error)) echo "<div class='error-message'>$error</div>"; ?>
                <?php if (isset($volumineux)) echo "<div class='error-message'>$volumineux</div>"; ?>
                <?php if (isset($format)) echo "<div class='error-message'>$format</div>"; ?>
                <?php if (isset($erreurUpload)) echo "<div class='error-message'>$erreurUpload</div>"; ?>
            </form>

            <!-- Lien de déconnexion -->
            <a class="logout-link" href="index.php?action=logout">Se Déconnecter</a>
        </div>

        <!-- Affichage de la photo de profil actuelle -->
        <div class="profile_img">
            <img src="./uploads/<?= htmlspecialchars(user_pp_current($_SESSION['user_id'])) ?>" alt="Photo de profil actuelle">
        </div>
    </section>
</body>

</html>
