<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="./Style/style.css">
    <title>Créer un nouveau billet</title>
</head>

<body class="create-post-body">

    <header>
        <?php if (connected_user() && !empty($comments)): ?>
            <div class="logo">
                <img src="./uploads/<?= htmlspecialchars($comments['photo_profil']) ?>" alt="Photo de profil">
            </div>
        <?php endif; ?>

        <!-- Menu de navigation -->
        <nav>
            <ul>
                <li><a href="index.php?action=home">Accueil</a></li>
                <li><a href="index.php?action=showArchives">Archives</a></li>
                
                <?php if (isAdmin()): ?>
                    <li><a href="index.php?action=precreate_post">Ajouter un Billet</a></li>
                    <li><a href="index.php?action=administration">Administration</a></li>
                <?php endif; ?>
            </ul>
        </nav>

        <!-- Navigation de droite pour le profil ou les liens de connexion -->
        <div class="right-nav">
            <ul>
                <?php if (connected_user()): ?>
                    <li><a href="index.php?action=profile">Mon Profil</a></li>
                <?php else: ?>
                    <li><a href="index.php?action=login">Connexion</a></li>
                    <li><a href="index.php?action=inscription">Inscription</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </header>

    <!-- Formulaire pour créer un billet -->
    <main>
        <form action="index.php?action=create_post" method="POST" class="create-post-form">
            <h1 class="create-post-title">Créer un nouveau billet</h1>

            <!-- Champ pour le titre -->
            <label for="titre" class="create-post-label">Titre</label>
            <input type="text" name="titre" id="titre" class="create-post-input" placeholder="Entrez le titre" required>

            <!-- Champ pour le contenu -->
            <label for="contenu" class="create-post-label">Contenu</label>
            <textarea name="contenu" id="contenu" class="create-post-textarea" rows="6" placeholder="Rédigez votre billet" required></textarea>

            <!-- Identifiant de l'auteur (peut être dynamique selon l'utilisateur connecté) -->
            <input type="hidden" name="auteur_id" value="<?= htmlspecialchars($_SESSION['user_id'] ?? 1) ?>">

            <!-- Bouton pour soumettre le formulaire -->
            <button type="submit" class="create-post-button">Publier le billet</button>

            <!-- Affichage d'un message d'erreur, s'il y en a -->
            <?php if (isset($error)): ?>
                <div class="error-message"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
        </form>
    </main>

</body>

</html>
