<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="./Style/style.css">
    <title>Inscription</title>
</head>

<body class="signup-body">
    <form method="POST" action="index.php?action=inscription" class="signup-form">
        <h1 class="signup-title">Inscription</h1>

        <!-- Champ pour le login -->
        <label for="login" class="signup-label">Login</label>
        <input 
            type="text" 
            name="login" 
            id="login" 
            placeholder="Nom d'utilisateur" 
            class="signup-input" 
            minlength="3" 
            maxlength="20" 
            pattern="[a-zA-Z0-9_-]+" 
            title="Le login doit contenir entre 3 et 20 caractères : lettres, chiffres, - ou _." 
            required>

        <!-- Champ pour le prénom -->
        <label for="prenom" class="signup-label">Prénom</label>
        <input 
            type="text" 
            name="prenom" 
            id="prenom" 
            placeholder="Prénom" 
            class="signup-input" 
            pattern="[a-zA-ZÀ-ÿ\s-]+" 
            title="Le prénom peut contenir des lettres, espaces et tirets uniquement." 
            required>

        <!-- Champ pour le nom -->
        <label for="nom" class="signup-label">Nom</label>
        <input 
            type="text" 
            name="nom" 
            id="nom" 
            placeholder="Nom" 
            class="signup-input" 
            pattern="[a-zA-ZÀ-ÿ\s-]+" 
            title="Le nom peut contenir des lettres, espaces et tirets uniquement." 
            required>

        <!-- Champ pour le mot de passe -->
        <label for="mot_de_passe" class="signup-label">Mot de passe</label>
        <input 
            type="password" 
            name="mot_de_passe" 
            id="mot_de_passe" 
            class="signup-input" 
            minlength="8" 
            title="Le mot de passe doit contenir au moins 8 caractères." 
            required>

        <!-- Champ pour confirmer le mot de passe -->
        <label for="confirmer_mot_de_passe" class="signup-label">Confirmer le mot de passe</label>
        <input 
            type="password" 
            name="confirmer_mot_de_passe" 
            id="confirmer_mot_de_passe" 
            class="signup-input" 
            minlength="8" 
            title="Veuillez confirmer votre mot de passe." 
            required>

        <!-- Bouton pour soumettre le formulaire -->
        <input type="submit" value="S'inscrire" class="signup-button">

        <!-- Message d'erreur -->
        <?php if (isset($error)): ?>
            <p class="error-message"><?= htmlspecialchars($error); ?></p>
        <?php endif; ?>
    </form>
</body>

</html>
