<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="./Style/style.css">
    <script src="./Controller/index.js" defer></script>
    <title>Details article</title>
</head>

<body>
    <header>

        <nav>
            <ul>
                <li><a href="index.php?action=home">Accueil</a></li>
                <li><a href="index.php?action=showArchives">Archives</a></li>
                <?php if (isAdmin()): ?>
                    <li><a href="index.php?action=precreate_post">Ajouter un Billet</a></li>
                    <li><a href="index.php?action=administration">Administration</a></li>
                <?php endif; ?>
            </ul>
        </nav>
        <div class="right-nav">
            <ul>
                <?php if (connected_user()): ?>
                    <li><a href="index.php?action=profile">Mon Profil</a></li>
                <?php else: ?>
                    <li><a href="index.php?action=login">Connexion</a></li>
                    <li><a href="index.php?action=inscription">Inscription</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </header>

  
    <main>
        <div class="introduction">
            <?php if (connected_user()): ?>
                <p>Découvrez les articles ci-dessous. Vous pouvez laissez vos commentaires pour participer à une discussion avec tous les utilisateurs.</p>
            <?php endif; ?>
        </div>

        <?php if (isset($_GET['id'])): ?>
            <?php
            $post = post_id($_GET['id']);
            if ($post): ?>
                <!-- Section des détails du billet -->
                <div class="post-detail">
                    <h2><?= htmlspecialchars($post['titre']) ?></h2>
                    <p><?= htmlspecialchars($post['contenu']) ?></p>
                    <div class="post-meta">
                        <small><em>Date de publication : <?= htmlspecialchars($post['date_post']) ?></em></small>
                    </div>
                </div>

                <!-- Section des commentaires -->
                <div class="comment_part">
                    <?php if (connected_user()): ?>
                        <h2>Ajouter un commentaire</h2>
                        <form action="index.php?action=comment_post&id=<?= intval($post['id_billets']) ?>" method="POST">
                            <div>
                                <label for="content_comments">Votre commentaire :</label><br>
                                <textarea name="content_comments" id="content_comments" rows="5" placeholder="Écrivez votre commentaire ici..." required></textarea><br>
                            </div>
                            <div>
                                <button type="submit">Poster le commentaire</button>
                                <?php if (isset($echecAjout)) echo htmlspecialchars($echecAjout); ?>
                            </div>
                        </form>
                    <?php endif; ?>

                    <!-- Liste des commentaires -->
                    <?php if (!empty($comments)): ?>
                        <h2>Commentaires</h2>
                        <div class="comments-container">
                            <!-- Bouton pour afficher/masquer -->
                            <button id="toggle-comments-btn">Voir les commentaires</button>
                            <div id="comments-section" class="comments-section">
                                <?php foreach ($comments as $comment): ?>
                                    <div class="comment">
                                        <?php if (!empty($comment['photo_profil'])): ?>
                                            <img src="./uploads/<?= htmlspecialchars($comment['photo_profil']) ?>" alt="Photo de profil" class="profile-photo"  style="height:70px; width:auto;">
                                        <?php else: ?>
                                            <img src="./uploads/photo_default.png" alt="Photo par défaut" class="profile-photo">
                                        <?php endif; ?>

                                        <p><?= htmlspecialchars($comment['contenu']) ?></p>
                                        <small>Posté par : <?= htmlspecialchars($comment['prenom'] . ' ' . $comment['nom']) ?> le <?= htmlspecialchars($comment['date_post']) ?></small>

                                        <?php if (isAdmin()): ?>
                                            <a href="index.php?action=delete_comments&id=<?= intval($comment['id_commentaires']) ?>" class="delete-link">Supprimer</a>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php else: ?>
                        <p>Aucun commentaire pour cet article.</p>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <p>Aucun article trouvé avec cet identifiant.</p>
            <?php endif; ?>
        <?php endif; ?>
    </main>

    <script>
        // Fonction pour afficher/masquer les commentaires
        function toggleComments() {
            const commentsSection = document.getElementById('comments-section');
            commentsSection.style.display = commentsSection.style.display === 'none' ? 'block' : 'none';
        }
    </script>
</body>

</html>
