<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="./Style/style.css">
    <title>Archives</title>
</head>

<body>
    <header>
        <?php if (connected_user() && !empty($comments)): ?>
            <div class="logo">
                <img src="./uploads/<?= htmlspecialchars($comments['photo_profil']) ?>" alt="Photo de profil">
            </div>
        <?php endif; ?>

        <nav>
            <ul>
                <li><a href="index.php?action=home">Accueil</a></li>
                <li><a href="index.php?action=showArchives">Archives</a></li>
                <?php if (isAdmin()): ?>
                    <li><a href="index.php?action=precreate_post">Ajouter un Billet</a></li>
                    <li><a href="index.php?action=administration">Administration</a></li>
                <?php endif; ?>
            </ul>
        </nav>

        <div class="right-nav">
            <ul>
                <?php if (connected_user()): ?>
                    <li><a href="index.php?action=profile">Mon Profil</a></li>
                <?php else: ?>
                    <li><a href="index.php?action=login">Connexion</a></li>
                    <li><a href="index.php?action=inscription">Inscription</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </header>

    <main>
        <h1 class="archive-title">Liste des archives</h1>
        <div class="archive-container">
            <?php foreach (all_posts() as $post): ?>
                <div class="post-item">
                    <h2 class="post-title"><?= htmlspecialchars($post['titre']) ?></h2>
                    <p class="post-content"><?= htmlspecialchars($post['contenu']) ?></p>
                    <small class="post-date"><?= htmlspecialchars($post['date_post']) ?></small>
                    <br>
                    <br>
                    <?php if (isAdmin()): ?>
                        <a href="index.php?action=delete_post&id=<?= intval($post['id_billets']) ?>" 
                           class="delete-button">Supprimer</a>
                           <br>
                           <br>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </main>
</body>

</html>
