<?php

function connexion(){
    $db = new PDO('mysql:host=localhost;dbname=gawryluk_mini_blog;port=8889;charset=utf8','gawryluk_mini_blog','azertyuiop2003');

        return $db;
}


/*UTILISATEURS*/

function login_exist($login){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT id_utilisateurs FROM utilisateurs WHERE login = ?");
    $query->execute([$login]);
    return $query->fetch() ? true : false;
}

function create_users($login, $prenom, $nom, $mot_de_passe_hash){
    $pdo = connexion();
    $query = $pdo->prepare("INSERT INTO utilisateurs (login, prenom, nom, mot_de_passe, photo_profil) VALUES (:login, :prenom, :nom, :mot_de_passe, NULL)");
    $query->bindValue(':login', $login);
    $query->bindValue(':prenom', $prenom);
    $query->bindValue(':nom', $nom);
    $query->bindValue(':mot_de_passe', $mot_de_passe_hash);
    $query->execute();
}

function register_users($user_data){
    // Récupérer les données du formulaire
    $login = htmlspecialchars($user_data['login']);
    $prenom = htmlspecialchars($user_data['prenom']);
    $nom = htmlspecialchars($user_data['nom']);
    $mot_de_passe = $user_data['mot_de_passe'];
    $mot_de_passe_hash = password_hash($mot_de_passe, PASSWORD_DEFAULT);

    $pdo = connexion();
    $query = $pdo->prepare("INSERT INTO utilisateurs (login, prenom, nom, mot_de_passe) VALUES (:login, :prenom, :nom, :mot_de_passe)");
    $query->bindValue(':login', $login);
    $query->bindValue(':prenom', $prenom);
    $query->bindValue(':nom', $nom);
    $query->bindValue(':mot_de_passe', $mot_de_passe_hash);
    $query->execute();
}

function login_users($user_data){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT id_utilisateurs, login, mot_de_passe, prenom, nom FROM utilisateurs WHERE login = :login");
    $query->bindParam(':login', $user_data['login'], PDO::PARAM_STR);
    $query->execute();
    $user = $query->fetch(PDO::FETCH_ASSOC);
    // Vérifier si un utilisateur est trouvé et comparer les mdp
    if ($user && password_verify($user_data['mot_de_passe'], $user['mot_de_passe'])) {
        // Déclaration des variables de sessions utiles pour la suite
        $_SESSION['user'] = $user['login'];
        $_SESSION['prenom'] = $user['prenom'];
        $_SESSION['nom'] = $user['nom'];
        $_SESSION['user_id'] = $user['id_utilisateurs'];

        return true;
    } else {
        return false;
    }
}

function registration_valid(){
    if (isset($_SESSION['registration_done']) && $_SESSION['registration_done'] === true) {
        return false;
    } if (
        isset($_POST['login']) && !empty($_POST['login']) &&
        isset($_POST['prenom']) && !empty($_POST['prenom']) &&
        isset($_POST['nom']) && !empty($_POST['nom']) &&
        isset($_POST['mot_de_passe']) && !empty($_POST['mot_de_passe'])
    ){
        $_SESSION['registration_done'] = true;
        return true;
    } else {
        return false;
    }}


function isAdmin(){
    return isset($_SESSION['user']) && $_SESSION['user'] === 'admin';
}

function connected_user(){
    return isset($_SESSION['user']);
}


function users_bdd($userId){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT COUNT(*) FROM utilisateurs WHERE id_utilisateurs = :id");
    $query->bindValue(':id', $userId);
    $query->execute();
    return $query->fetchColumn() > 0;
}

function show_users(){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT * FROM utilisateurs");
    $query->execute();
    $allUsers = $query->fetchAll(PDO::FETCH_ASSOC);
    return $allUsers;
}

function delete_users($id_utilisateurs){

    $pdo = connexion();
    
    // $stmt = $pdo->prepare("DELETE FROM commentaires WHERE auteur_id = :id_utilisateurs");
    // $stmt->bindParam(':id_utilisateurs', $id_user, PDO::PARAM_INT);
    // $stmt->execute();

    // $query = $pdo->prepare("DELETE FROM utilisateurs WHERE id_utilisateurs = :id_utilisateurs");
    // $query->bindValue(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    // $query->execute();


     // Supprimer les commentaires liés aux billets de l'utilisateur
     $stmt = $pdo->prepare("DELETE FROM commentaires WHERE billet_id IN (
        SELECT id_billets FROM billets WHERE auteur_id = :id_utilisateurs
    )");
    $stmt->bindParam(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    $stmt->execute();
    // Supprimer les commentaires écrits directement par l'utilisateur
    $stmt = $pdo->prepare("DELETE FROM commentaires WHERE auteur_id = :id_utilisateurs");
    $stmt->bindParam(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    $stmt->execute();
    // Supprimer les billets de l'utilisateur
    $stmt = $pdo->prepare("DELETE FROM billets WHERE auteur_id = :id_utilisateurs");
    $stmt->bindParam(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    $stmt->execute();
    // Supprimer l'utilisateur
    $stmt = $pdo->prepare("DELETE FROM utilisateurs WHERE id_utilisateurs = :id_utilisateurs");
    $stmt->bindParam(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    $stmt->execute();
    

    
}


function update_users($id_utilisateurs, $data_update){
    $pdo = connexion();
    $query = $pdo->prepare("UPDATE utilisateurs SET nom = :nom, prenom = :prenom, login = :login WHERE id_utilisateurs = :id_utilisateurs");
    $query->bindValue(':nom', $data_update['nom']);
    $query->bindValue(':prenom', $data_update['prenom']);
    $query->bindValue(':login', $data_update['login']);
    $query->bindValue(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    $query->execute();
}



/*POST*/

function create_post($titre, $contenu, $auteurId){
    $pdo = connexion();
    $query = $pdo->prepare("INSERT INTO billets (id_billets, titre, contenu, date_post, auteur_id) VALUES (NULL ,:titre, :contenu, NOW(), :auteur_id)");
    $query->bindValue(':titre', $titre);
    $query->bindValue(':contenu', $contenu);
    $query->bindValue(':auteur_id', $auteurId);

    if ($query->execute()){
        return "Billet créé avec succès";
    }
    return "Erreur lors de la création du billet";
}

function latest_posts(){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT id_billets, titre, contenu, date_post, auteur_id FROM billets ORDER BY date_post DESC LIMIT 3");
    $query->execute();
    $posts = $query->fetchAll(PDO::FETCH_ASSOC);
    return $posts;
}

function post_id($id){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT id_billets, titre, contenu, date_post, auteur_id FROM billets WHERE id_billets = :id");
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->execute();
    $post = $query->fetch(PDO::FETCH_ASSOC);
    return $post;
}

function all_posts(){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT id_billets, titre, contenu, date_post, auteur_id FROM billets ORDER BY date_post ASC");
    $query->execute();
    $posts = $query->fetchAll(PDO::FETCH_ASSOC);
    return $posts;
}


function delete_post($id_billets){
    $pdo = connexion();
    $query = $pdo->prepare("DELETE FROM billets WHERE id_billets = :id_billets");
    $query->bindValue(':id_billets', $id_billets, PDO::PARAM_INT);
    $query->execute();
}


function update_post($id_billets, $data_update){
    $pdo = connexion();
    $query = $pdo->prepare("UPDATE billets SET titre = :titre, contenu = :contenu WHERE id_billets = :id_billets");
    $query->bindValue(':titre', $data_update['titre']);
    $query->bindValue(':contenu', $data_update['contenu']);
    $query->bindValue(':id_billets', $id_billets, PDO::PARAM_INT);
    $query->execute();
}



/*COMMENTAIRES*/

function all_comments(){
    $db = connexion();
    $query = $db->prepare('SELECT * FROM commentaires');
    $query->execute();
    $list_comments = $query->fetchAll(PDO::FETCH_ASSOC);
    return $list_comments;
}

function comment_post($id_post, $userId, $content_comments){
    $pdo = connexion();
    $query = $pdo->prepare("INSERT INTO commentaires (id_commentaires, contenu, date_post, auteur_id, billet_id) VALUES (NULL, :contenu, NOW(), :auteur_id, :billet_id)");
    $query->bindValue(':billet_id', $id_post, PDO::PARAM_INT);
    $query->bindValue(':auteur_id', $userId, PDO::PARAM_INT);
    $query->bindValue(':contenu', htmlspecialchars($content_comments), PDO::PARAM_STR);
    return $query->execute();
}

function show_comments($id_post){
    $pdo = connexion();
    $query = $pdo->prepare("
        SELECT c.id_commentaires, c.contenu, c.date_post, u.prenom, u.nom, u.photo_profil
        FROM commentaires c
        JOIN utilisateurs u ON c.auteur_id = u.id_utilisateurs
        WHERE c.billet_id = :id_post
        ORDER BY c.date_post DESC");
    $query->bindValue(':id_post', $id_post, PDO::PARAM_INT);
    $query->execute();
    return $query->fetchAll(PDO::FETCH_ASSOC);
}


function delete_comments($id_commentaires){
    $pdo = connexion();
    $query = $pdo->prepare("DELETE FROM commentaires WHERE id_commentaires = :id_commentaires");
    $query->bindValue(":id_commentaires", $id_commentaires);
    $query->execute();
}

function comments_id($id_commentaires){
    $pdo = connexion();
    $query = $pdo->prepare("SELECT id_commentaires FROM commentaires WHERE id_commentaires = :id_commentaires");
    $query->bindParam(':id_commentaires', $id_commentaires, PDO::PARAM_INT);
    $query->execute();
    $comment = $query->fetch(PDO::FETCH_ASSOC);
    return $comment;
}

function update_comments($id_commentaires, $data_update){
    $pdo = connexion();
    $query = $pdo->prepare("UPDATE commentaires SET contenu = :contenu WHERE id_commentaires = :id_commentaires");
    $query->bindValue(':contenu', $data_update['contenu']);
    $query->bindValue(':id_commentaires', $id_commentaires, PDO::PARAM_STR);
    $query->execute();
}



/*PHOTO DE PROFIL*/

function user_pp_current($id_utilisateurs){
    $pdo = connexion();
    $stmt = $pdo->prepare("SELECT photo_profil FROM utilisateurs WHERE id_utilisateurs = :id_utilisateurs");
    $stmt->bindParam(':id_utilisateurs', $id_utilisateurs, PDO::PARAM_INT);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    return $result ? $result['photo_profil'] : '/Miniblog/uploads/photo_default.png';
}


function upload_user_pp($uniqueFileName, $id_utilisateurs){
    $pdo = connexion();
    $stmt = $pdo->prepare("UPDATE utilisateurs SET photo_profil = :photo_profil WHERE id_utilisateurs = :id_utilisateurs");
    $stmt->bindParam(':photo_profil', $uniqueFileName);
    $stmt->bindParam(':id_utilisateurs', $id_utilisateurs);
    $stmt->execute();
}

