// Limiter le nombre de caractères et masquer le reste
const textElements = document.querySelectorAll(".post-content");

textElements.forEach((text) => {
  if (text.textContent.length > 150) {
    const shortText = text.textContent.slice(0, 150) + "...";
    text.textContent = shortText;
  }
});


function toggleCommentForm(commentId) {
  const formContainer = document.getElementById(`update-form-${commentId}`);
  const btnComment = document.querySelector('.btnComment');

  // Vérifier si le formulaire est déjà visible
  if (formContainer.style.display === "block") {
      formContainer.style.display = "none";
      btnComment.style.display = "none";
  } else {
    formContainer.style.display = "block";
  }
}


// Gestion des erreurs :

document.querySelector("form.signup-form").addEventListener("submit", function (e) {
    let hasError = false;

    // Réinitialiser les messages d'erreur
    document.querySelectorAll(".error-message").forEach(msg => (msg.style.display = "none"));

    const login = document.getElementById("login").value.trim();
    const password = document.getElementById("mot_de_passe").value.trim();
    const confirmPassword = document.getElementById("confirm_mot_de_passe").value.trim();

    if (login.length < 3) {
        document.getElementById("error-login").style.display = "block";
        hasError = true;
    }

    if (password.length < 8) {
        document.getElementById("error-password").style.display = "block";
        hasError = true;
    }

    if (password !== confirmPassword) {
        document.getElementById("error-confirm-password").style.display = "block";
        hasError = true;
    }

    if (hasError) {
        e.preventDefault();
    }
});